import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import javax.media.*;
import javax.media.format.*;

/* Version 1.0 , released October 7 2003 */
/* This is a simpel example using the UsbCamera Class */
/* For a description of the API see UsbCamera.java */

public class Driver {
    public static void main(String args[]) {
	Driver go = new Driver();
    }

    private UsbCamera cam;
    private PicCanvas canvas;
    private Container windowPane;

    public Driver() {
	/* Get our camera instance */
	cam = UsbCamera.getInstance();

	/* Display the window */
	cam.setVisible(true);

	/* Now Loop */
	while(true) {
	    /* Take a picture */
	    cam.snap();

	    for(int i=0; i<cam.XSIZE; i++) {
		for(int j=0;j<cam.YSIZE; j++) {
		    try {
			cam.getRawPixel(i,j);
		    } catch (Exception e) {
			System.out.println(e+" at " + i + "," + j);
		    }
		}
	    }

	    /* Print out a random pixel */
	    int pixel[] = cam.getPixel(30, 30);

	    System.out.println(" r:"+pixel[UsbCamera.RED]+
			       " g:"+pixel[UsbCamera.GREEN]+
			       " b:"+pixel[UsbCamera.BLUE]);

	    cam.setRect(25,25,10,10);

      	    try {
		Thread.sleep(100);
	    } catch (InterruptedException e) {}

	    cam.unsetRect();

	    try {
		Thread.sleep(100);
	    } catch (InterruptedException e) {}
	}
    }
}
